package mole.entities.controlers
{
	import mole.entities.items.IItem;
	import mole.entities.CPlayer;
	import net.flashpunk.FP;
	import net.flashpunk.utils.Input;
	import net.flashpunk.utils.Key;
	
	/**
	 * Controlleur d'un joueur humain.
	 * @author Cédric Liaudet
	 */
	public class CPlayerControler implements IControler
	{		
		/**
		 * Constructeur par défaut.
		 */
		public function CPlayerControler() 
		{			
			// Déplacements
			Input.define("jump", Key.E);
			Input.define("down", Key.R);
		}
		
		/**
		 * Callback de mise à jours du controlleur.
		 */
		public function update(_Player:CPlayer):void
		{
			// Saut
			if (Input.pressed("jump"))
			{
				_Player.OnJump();
			}
			else if (Input.released("jump"))
			{
				_Player.ReleaseJump();
			}
			
			
			// Accroupie.
			if (Input.pressed("down"))
			{				
				_Player.OnDown();
			}
			else if (Input.released("down"))
			{
				_Player.OnUp();
			}
		}
		
		/**
		 * Renvoie la vitesse du controlleur.
		 * @return La vitesse du controlleur.
		 */
		public function GetSpeed():int
		{
			return 0;
		}
	}

}